SteerableExtension = {}
function SteerableExtension.prerequisitesPresent(specializations)
  return SpecializationUtil.hasSpecialization(Steerable, specializations)
end
function SteerableExtension:load(xmlFile)
  self.supportsFlapByDefault = true
  if self.exhaustParticleSystems.flap == nil then
    self.exhaustParticleSystems.flap = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.exhaustParticleSystems#flap"))
    self.exhaustParticleSystems.maxRot = Utils.degToRad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.exhaustParticleSystems#maxRot"), 0))
    self.exhaustParticleSystems.maxRpm = self.motor:getMaxRpm()
    self.supportsFlapByDefault = false
    self.exhaustParticleSystems.minScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.exhaustParticleSystems#minScale"), 0.4)
    self.exhaustParticleSystems.maxScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.exhaustParticleSystems#maxScale"), 1)
    for _, v in ipairs(self.exhaustParticleSystems) do
      v.originalLifespan = getParticleSystemLifespan(v.geometry)
    end
  end
  self.indoorDisplay = {}
  local speed = {}
  speed.one = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indoorDisplay.speed#one"))
  speed.ten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indoorDisplay.speed#ten"))
  speed.float = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indoorDisplay.speed#float"))
  if speed.one ~= nil then
    self.indoorDisplay.speed = speed
  end
end
function SteerableExtension:delete()
end
function SteerableExtension:mouseEvent(posX, posY, isDown, isUp, button)
end
function SteerableExtension:keyEvent(unicode, sym, modifier, isDown)
end
function SteerableExtension:update(dt)
  if self:getIsActive() and not self.supportsFlapByDefault then
    local rpmPercent = self.motor.lastMotorRpm / self.exhaustParticleSystems.maxRpm
    local scale = self.exhaustParticleSystems.minScale + (self.exhaustParticleSystems.maxScale - self.exhaustParticleSystems.minScale) * rpmPercent
    Utils.setEmitCountScale(self.exhaustParticleSystems, scale)
    for _, ps in ipairs(self.exhaustParticleSystems) do
      setParticleSystemLifespan(ps.geometry, ps.originalLifespan * scale, true)
    end
    if self.exhaustParticleSystems.flap ~= nil then
      local minRandom = -0.1
      local maxRandom = 0.1
      local angle = math.random() * (maxRandom - minRandom) + minRandom + self.exhaustParticleSystems.maxRot * rpmPercent
      angle = math.min(math.max(angle, 0), self.exhaustParticleSystems.maxRot)
      setRotation(self.exhaustParticleSystems.flap, angle, 0, 0)
    end
  end
end
function SteerableExtension:updateTick(dt)
  if self:getIsActive() and self.indoorDisplay.speed ~= nil then
    local speedDisplay = self.indoorDisplay.speed
    local kmh = math.min(99.9, math.max(0, self.lastSpeed * self.speedDisplayScale * 3600))
    local speed = tonumber(string.format("%.1f", g_i18n:getSpeed(kmh)))
    local one = math.floor(speed) % 10
    setShaderParameter(speedDisplay.one, "number", one, 0, 0, 0, false)
    if speedDisplay.float ~= nil then
      local float = speed * 10 - math.floor(speed) * 10
      setShaderParameter(speedDisplay.float, "number", float, 0, 0, 0, false)
    end
    if speedDisplay.ten ~= nil then
      local ten = -1
      if speed >= 10 then
        ten = (math.floor(speed) - one) / 10
      end
      setShaderParameter(speedDisplay.ten, "number", ten, 0, 0, 0, false)
    end
  end
end
function SteerableExtension:draw()
end
